/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.translations.repository;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.impactdev.impactor.api.translations.TranslationManager;
import net.impactdev.impactor.api.translations.metadata.LanguageInfo;
import net.impactdev.impactor.api.translations.repository.TranslationEndpoint;
import net.impactdev.impactor.api.translations.repository.TranslationRepository;
import net.impactdev.impactor.api.utility.Context;
import net.impactdev.impactor.api.utility.ExceptionPrinter;
import net.impactdev.impactor.core.plugin.BaseImpactorPlugin;
import net.impactdev.impactor.core.translations.ImpactorTranslationManager;
import net.impactdev.impactor.core.translations.builders.ImpactorTranslationRepositoryBuilder;
import net.impactdev.impactor.core.translations.internal.ImpactorTranslations;
import net.impactdev.impactor.core.translations.repository.LimitedInputStream;
import net.impactdev.impactor.core.translations.repository.MetadataResponse;
import net.impactdev.impactor.core.translations.repository.TranslationsClient;
import net.impactdev.impactor.core.utility.future.Futures;
import net.impactdev.impactor.relocations.okhttp3.Request;
import net.impactdev.impactor.relocations.okhttp3.Response;
import net.impactdev.impactor.relocations.okhttp3.ResponseBody;
import net.kyori.adventure.audience.Audience;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.jetbrains.annotations.NotNull;

public class ImpactorTranslationRepository
implements TranslationRepository {
    private static final Gson SIMPLE = new GsonBuilder().create();
    private static final Gson PRETTY = new GsonBuilder().setPrettyPrinting().create();
    private final Map<TranslationEndpoint, String> urls = Maps.newHashMap();
    private final long maxBundleSize;
    private final long cacheMaxAge;
    private final Supplier<Boolean> refreshRule;
    private final TranslationsClient client = new TranslationsClient();
    private @MonotonicNonNull TranslationManager manager;

    public ImpactorTranslationRepository(ImpactorTranslationRepositoryBuilder builder) {
        this.urls.putAll(builder.urls);
        this.maxBundleSize = builder.maxBundleSize;
        this.cacheMaxAge = builder.maxCacheAge;
        this.refreshRule = builder.rule;
    }

    @Override
    public CompletableFuture<Set<LanguageInfo>> available() {
        return Futures.execute(() -> this.fetchTranslationsMetadata().languages());
    }

    @Override
    public CompletableFuture<Boolean> refresh() {
        return Futures.execute(() -> {
            long last = this.readLastRefreshTime();
            long since = System.currentTimeMillis() - last;
            if (this.refreshRule != null && !this.refreshRule.get().booleanValue()) {
                System.out.println();
                return false;
            }
            if (since <= this.cacheMaxAge) {
                return false;
            }
            MetadataResponse metadata = this.fetchTranslationsMetadata();
            if (since <= metadata.age()) {
                return false;
            }
            ((CompletableFuture)this.available().thenApply(languages -> this.downloadAndInstall((Set<LanguageInfo>)languages, Audience.empty(), true))).join();
            return true;
        });
    }

    @Override
    public CompletableFuture<Void> downloadAndInstall(@NotNull Set<LanguageInfo> languages, @NotNull Audience audience, boolean update) {
        return Futures.execute(() -> {
            try {
                Path target = this.manager.root().resolve("repository");
                this.clear(target, ImpactorTranslationManager::isConfigurationFile);
                try {
                    Files.createDirectories(target, new FileAttribute[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                for (LanguageInfo language : languages) {
                    Context context = Context.empty();
                    context.append(LanguageInfo.class, language);
                    ImpactorTranslations.TRANSLATIONS_INSTALLING_LANGUAGE.send(audience, context);
                    Request request = new Request.Builder().header("User-Agent", "Impactor/Translations").url(String.format(this.urls.get((Object)TranslationEndpoint.DOWNLOADABLE_LANGUAGE), language.id())).build();
                    try {
                        Response response = this.client.makeRequest(request);
                        try {
                            ResponseBody body = response.body();
                            try {
                                if (body == null) {
                                    throw new IOException("No response from translations server");
                                }
                                Path file = target.resolve(String.valueOf(language.locale()) + ".conf");
                                try (LimitedInputStream stream = new LimitedInputStream(body.byteStream(), this.maxBundleSize);){
                                    Files.copy(stream, file, StandardCopyOption.REPLACE_EXISTING);
                                }
                            }
                            finally {
                                if (body == null) continue;
                                body.close();
                            }
                        }
                        finally {
                            if (response == null) continue;
                            response.close();
                        }
                    }
                    catch (Exception e) {
                        ImpactorTranslations.TRANSLATIONS_INSTALL_FAILED.send(audience, context);
                        ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
                    }
                }
                if (update) {
                    this.writeLastRefreshTime();
                }
                this.manager.reload();
            }
            catch (Exception e) {
                ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
            }
        });
    }

    public void manager(@NotNull TranslationManager manager) {
        this.manager = manager;
    }

    private void clear(Path directory, Predicate<Path> filter) {
        try (Stream<Path> paths = Files.list(directory).filter(filter);){
            paths.forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeLastRefreshTime() {
        Path statusFile = this.manager.root().resolve("repository").resolve("status.json");
        try (BufferedWriter writer = Files.newBufferedWriter(statusFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonObject status = new JsonObject();
            status.add("lastRefresh", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
            PRETTY.toJson((JsonElement)status, (Appendable)writer);
        }
        catch (IOException e) {
            ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long readLastRefreshTime() {
        Path statusFile = this.manager.root().resolve("repository").resolve("status.json");
        if (!Files.exists(statusFile, new LinkOption[0])) return 0L;
        try (BufferedReader reader = Files.newBufferedReader(statusFile, StandardCharsets.UTF_8);){
            JsonObject status = (JsonObject)SIMPLE.fromJson((Reader)reader, JsonObject.class);
            if (!status.has("lastRefresh")) return 0L;
            long l = status.get("lastRefresh").getAsLong();
            return l;
        }
        catch (Exception e) {
            ExceptionPrinter.print(BaseImpactorPlugin.instance().logger(), e);
        }
        return 0L;
    }

    private MetadataResponse fetchTranslationsMetadata() throws Exception {
        JsonObject jsonResponse;
        Request request = new Request.Builder().header("User-Agent", "Impactor/Translations").url(this.urls.get((Object)TranslationEndpoint.LANGUAGE_SET)).build();
        try (Response response = this.client.makeRequest(request);
             ResponseBody responseBody = response.body();){
            if (responseBody == null) {
                throw new RuntimeException("No response");
            }
            try (LimitedInputStream inputStream2 = new LimitedInputStream(responseBody.byteStream(), this.maxBundleSize);
                 BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream2, StandardCharsets.UTF_8));){
                jsonResponse = (JsonObject)SIMPLE.fromJson((Reader)reader, JsonObject.class);
            }
        }
        LinkedHashSet<LanguageInfo> languages = new LinkedHashSet<LanguageInfo>();
        for (Map.Entry language2 : jsonResponse.get("languages").getAsJsonObject().entrySet()) {
            languages.add(new LanguageInfo((String)language2.getKey(), ((JsonElement)language2.getValue()).getAsJsonObject()));
        }
        languages.removeIf(language -> language.progress() <= 0);
        if (languages.size() >= 100) {
            throw new IOException("More than 100 languages - cancelling download");
        }
        long cacheMaxAge = jsonResponse.get("timestamp").getAsLong();
        return new MetadataResponse(cacheMaxAge, languages);
    }

    public void shutdown() {
        this.client.shutdown();
    }
}

